//
//  TextScene.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//

import SpriteKit
import SPCScene
import Canvas


public class TextScene: Scene, SceneAnimating {
    static let backgroundColor = #colorLiteral(red: 0.0, green: 0.0, blue: 0.0, alpha: 1.0)
    static let textColor = #colorLiteral(red: 1.0, green: 1.0, blue: 1.0, alpha: 1.0)
    
    var bg: Graphic
    var delay: Double
    
    public init(says copy: String, wait: Double = -1.0) {
        bg = Graphic.init(shape: .rectangle(width: 1024, height: 1024, cornerRadius: 0), color: TextScene.backgroundColor)
        delay = wait
        super.init(size: Scene.sceneSize)
        
        self.place(bg, at: Point.center)
        
        let text = Text(copy, size: Size(width: 960, height: 96))
        text.alignment = .center
        text.textColor = TextScene.textColor
        text.fontName = "Songkhla-Regular"
        text.fontSize = 32
        
        self.place(text, at: Point.center)
    }

    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    // MARK: - SceneAnimating
    
    public var sceneTransition: SKTransition?
    public var animationDelegate: SceneAnimatingDelegate?
    public var loadingDescription: String? {
        didSet {
            enableAccessibility(label: loadingDescription!)
        }
    }
    
    public func sceneIsPresented() {
        animationDelegate?.sceneDidLoad(self)
        if delay > 0 {
            bg.run(SKAction.wait(forDuration: delay)) {
                self.animationDelegate?.sceneDidFinishAnimations(self)
            }
        }
    }
    
    public func sceneWillDismiss() {
        
    }
}
